const siteName = "Yoryuhub";
const siteUrl = "https://your-frontend.com";
const brandGradient = "background: linear-gradient(90deg, #a78bfa 0%, #f472b6 100%);";

function baseTemplate(content, title = "") {
  return `
    <div style="font-family: 'Segoe UI', Arial, sans-serif; ${brandGradient} min-height:100vh; padding:40px 0;">
      <div style="max-width:480px;margin:40px auto;background:white;border-radius:18px;box-shadow:0 4px 24px #0001;padding:32px 24px;">
        <div style="display:flex;align-items:center;gap:10px;margin-bottom:24px;">
          <div style="width:40px;height:40px;${brandGradient}border-radius:10px;display:flex;align-items:center;justify-content:center;">
            <span style="color:white;font-weight:bold;font-size:18px;">H</span>
          </div>
          <span style="font-weight:bold;font-size:22px;color:#4b006e;">${siteName}</span>
        </div>
        <h2 style="font-size:20px;font-weight:600;color:#4b006e;margin-bottom:18px;">${title}</h2>
        <div style="color:#444;font-size:16px;line-height:1.7;">
          ${content}
        </div>
        <div style="margin-top:32px;font-size:13px;color:#aaa;text-align:center;">
          &copy; ${new Date().getFullYear()} ${siteName}
        </div>
      </div>
    </div>
  `;
}

function verifyEmailTemplate(link) {
  return baseTemplate(
    `
      <p>Thank you for registering on <b>${siteName}</b>!</p>
      <p>Please verify your email address by clicking the button below:</p>
      <div style="text-align:center;margin:32px 0;">
        <a href="${link}" style="display:inline-block;padding:12px 32px;border-radius:8px;background:linear-gradient(90deg,#a78bfa,#f472b6);color:white;font-weight:600;text-decoration:none;font-size:16px;">Verify Email</a>
      </div>
      <p>If you did not create an account, you can ignore this email.</p>
    `,
    "Verify Your Email"
  );
}

function resetPasswordTemplate(link) {
  return baseTemplate(
    `
      <p>We received a request to reset your password for your <b>${siteName}</b> account.</p>
      <p>Click the button below to set a new password:</p>
      <div style="text-align:center;margin:32px 0;">
        <a href="${link}" style="display:inline-block;padding:12px 32px;border-radius:8px;background:linear-gradient(90deg,#a78bfa,#f472b6);color:white;font-weight:600;text-decoration:none;font-size:16px;">Reset Password</a>
      </div>
      <p>If you did not request this, you can safely ignore this email.</p>
    `,
    "Reset Your Password"
  );
}

module.exports = {
  verifyEmailTemplate,
  resetPasswordTemplate,
};